/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateFormatter {
    private DateFormat mDateFormat;
    private DateFormat mTimeFormat;
    private DateFormat mDateTimeFormat;
    private Locale mCurLocale;
    private static DateFormatter mDefInst = null;

    public static synchronized DateFormatter getDefaultInstance() {
        if (mDefInst == null) {
            String[] stringArray = new String[]{"MM/dd/yyyy***HH:mm:ss***en***US", "MM/dd/yyyy***HH:mm:ss***en***C"};
            mDefInst = new DateFormatter(null, "***", stringArray);
        }
        return mDefInst;
    }

    public DateFormatter(Locale locale, String string, String[] stringArray) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && !(bl = this.mapLocaleFormat(locale, string, stringArray[i])); ++i) {
            }
        }
        if (!bl) {
            this.mDateFormat = DateFormat.getDateInstance();
            this.mTimeFormat = DateFormat.getTimeInstance();
            this.mDateTimeFormat = DateFormat.getDateTimeInstance();
        }
    }

    private boolean mapLocaleFormat(Locale locale, String string, String string2) {
        String string3;
        int n = 0;
        int n2 = 0;
        String string4 = locale.getLanguage();
        if (string4 == null || string4.length() == 0) {
            string4 = "en";
        }
        if ((string3 = locale.getCountry()) == null || string3.length() == 0) {
            string3 = "C";
        }
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            n2 = string2.indexOf(string, n);
            stringArray[i] = n2 == -1 ? string2.substring(n) : string2.substring(n, n2);
            n = n2 + string.length();
        }
        if (string4.equals(stringArray[2]) && string3.equals(stringArray[3])) {
            this.mDateFormat = new SimpleDateFormat(stringArray[0], locale);
            this.mTimeFormat = new SimpleDateFormat(stringArray[1], locale);
            this.mDateTimeFormat = new SimpleDateFormat(stringArray[0] + " " + stringArray[1], locale);
            return true;
        }
        return false;
    }

    public String formatDate(Date date) {
        return this.mDateFormat.format(date);
    }

    public String formatDate(long l) {
        Date date = new Date(l);
        return this.mDateFormat.format(date);
    }

    public String formatTime(Date date) {
        return this.mTimeFormat.format(date);
    }

    public String formatTime(long l) {
        Date date = new Date(l);
        return this.mTimeFormat.format(date);
    }

    public String formatDateTime(Date date) {
        return this.mDateTimeFormat.format(date);
    }

    public String formatDateTime(long l) {
        Date date = new Date(l);
        return this.mDateTimeFormat.format(date);
    }

    public long getDateTimeInMillis(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, n4, n5, n6);
        return calendar.getTimeInMillis();
    }

    public Date getDateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, n4, n5, n6);
        return calendar.getTime();
    }
}

